/*
 * DamageActor.h
 *
 * Created 8/18/2009 By Johnny Huynh
 *
 * Version 00.00.01 8/18/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef DAMAGE_ACTOR_H
 #define DAMAGE_ACTOR_H
 
 template <typename T> class DamageActor;
 
 #include "CollisionActor.h"
 #include "DamageObject.h"
 
 #include "global.h"
 
 /**
  * Class specification for DamageActor
  * DamageActors are Actors that deal damage
  */
 template <typename T>
 class DamageActor : virtual public DamageObject<T>, public CollisionActor<T>
 {
 // Data Members
 private:
 
 // Local Functions
 public:
    DamageActor( const std::string& name, const T& damage = ZERO, const EffectInfoCollection<T>& effect_info_collection = EffectInfoCollection<T>() );
    DamageActor( const DamageActor<T>& dmg_actor );
    virtual ~DamageActor();
    inline DamageActor<T>& operator=( const DamageActor<T>& dmg_actor );
    virtual inline std::string get_default_collider_name() const = 0;
    //virtual inline bool is_damage_object() const;
    virtual inline void load_model( WindowFramework& window ) = 0;
    virtual inline void load_model( WindowFramework& window, const NodePath& parent ) = 0;
    
    // overloaded functions (NodePath)
    /*static void init_type() {
                                std::string template_type( typeid( T ).name() );
                                register_type(_type_handle, "DamageActor<" + template_type + ">" );
                            }*/
 
 // Private Functions
 private:
    
 // Friend Functions
 public:
    
 };
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  */
 template <typename T>
 DamageActor<T>::DamageActor( const std::string& name, const T& damage = ZERO, const EffectInfoCollection<T>& effect_info_collection = EffectInfoCollection<T>() )
                 : DamageObject<T>( name, damage, effect_info_collection ),
                   CollisionActor<T>()
 {
    
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 DamageActor<T>::DamageActor( const DamageActor<T>& dmg_actor )
                : DamageObject<T>( static_cast< DamageObject<T> >( dmg_actor ) ),
                  CollisionActor<T>()
 {
    
 }
 
 /**
  * Destructor
  */
 template <typename T>
 DamageActor<T>::~DamageActor()
 {
    
 }
 
 /**
  * operator=() copies the content of the specified DamageActor to this DamageActor.
  *
  * @param (const DamageActor<T>& dmg_actor )
  * @return DamageActor<T>&
  */
 template <typename T>
 inline DamageActor<T>& DamageActor<T>::operator=( const DamageActor<T>& dmg_actor )
 {
    DamageObject<T>::operator=( static_cast< DamageObject<T> >( dmg_actor ) );
    CollisionActor<T>::operator=( static_cast< CollisionActor<T> >( dmg_actor ) );
    
    return *this;
 }
 
 /**
  * is_damage_object() returns true if this is a DamageObject; otherwise,
  * false is returned.
  *
  * @return bool
  */
 //template <typename T>
 //inline bool DamageActor<T>::is_damage_object() const
 //{
 //   return true;
 //}
 
 /** PRIVATE FUNCTIONS **/
 
 /** FRIEND FUNCTIONS **/
 
 #endif // DAMAGE_ACTOR_H